@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Application gateway probe health response match.
 * @property body Body that must be contained in the health response. Default value is empty.
 * @property statusCodes Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
 */
public data class ApplicationGatewayProbeHealthResponseMatchResponse(
    public val body: String? = null,
    public val statusCodes: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayProbeHealthResponseMatchResponse):
            ApplicationGatewayProbeHealthResponseMatchResponse =
            ApplicationGatewayProbeHealthResponseMatchResponse(
                body = javaType.body().map({ args0 -> args0 }).orElse(null),
                statusCodes = javaType.statusCodes().map({ args0 -> args0 }),
            )
    }
}
