@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Redirect configuration of an application gateway.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property includePath Include path in the redirected url.
 * @property includeQueryString Include query string in the redirected url.
 * @property name Name of the redirect configuration that is unique within an Application Gateway.
 * @property pathRules Path rules specifying redirect configuration.
 * @property redirectType HTTP redirection type.
 * @property requestRoutingRules Request routing specifying redirect configuration.
 * @property targetListener Reference to a listener to redirect the request to.
 * @property targetUrl Url to redirect the request to.
 * @property type Type of the resource.
 * @property urlPathMaps Url path maps specifying default redirect configuration.
 */
public data class ApplicationGatewayRedirectConfigurationResponse(
    public val etag: String,
    public val id: String? = null,
    public val includePath: Boolean? = null,
    public val includeQueryString: Boolean? = null,
    public val name: String? = null,
    public val pathRules: List<SubResourceResponse>? = null,
    public val redirectType: String? = null,
    public val requestRoutingRules: List<SubResourceResponse>? = null,
    public val targetListener: SubResourceResponse? = null,
    public val targetUrl: String? = null,
    public val type: String,
    public val urlPathMaps: List<SubResourceResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayRedirectConfigurationResponse):
            ApplicationGatewayRedirectConfigurationResponse =
            ApplicationGatewayRedirectConfigurationResponse(
                etag = javaType.etag(),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                includePath = javaType.includePath().map({ args0 -> args0 }).orElse(null),
                includeQueryString = javaType.includeQueryString().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                pathRules = javaType.pathRules().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }),
                redirectType = javaType.redirectType().map({ args0 -> args0 }).orElse(null),
                requestRoutingRules = javaType.requestRoutingRules().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }),
                targetListener = javaType.targetListener().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                targetUrl = javaType.targetUrl().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
                urlPathMaps = javaType.urlPathMaps().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
