@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * SSL profile of an application gateway.
 * @property clientAuthConfiguration Client authentication configuration of the application gateway resource.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Name of the SSL profile that is unique within an Application Gateway.
 * @property provisioningState The provisioning state of the HTTP listener resource.
 * @property sslPolicy SSL policy of the application gateway resource.
 * @property trustedClientCertificates Array of references to application gateway trusted client certificates.
 * @property type Type of the resource.
 */
public data class ApplicationGatewaySslProfileResponse(
    public val clientAuthConfiguration: ApplicationGatewayClientAuthConfigurationResponse? = null,
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val sslPolicy: ApplicationGatewaySslPolicyResponse? = null,
    public val trustedClientCertificates: List<SubResourceResponse>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewaySslProfileResponse):
            ApplicationGatewaySslProfileResponse = ApplicationGatewaySslProfileResponse(
            clientAuthConfiguration = javaType.clientAuthConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayClientAuthConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            sslPolicy = javaType.sslPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewaySslPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            trustedClientCertificates = javaType.trustedClientCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
