@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Rule condition of type application.
 * @property description Description of the rule condition.
 * @property destinationAddresses List of destination IP addresses or Service Tags.
 * @property fqdnTags List of FQDN Tags for this rule condition.
 * @property name Name of the rule condition.
 * @property protocols Array of Application Protocols.
 * @property ruleConditionType Rule Condition Type.
 * Expected value is 'ApplicationRuleCondition'.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 * @property targetFqdns List of FQDNs for this rule condition.
 */
public data class ApplicationRuleConditionResponse(
    public val description: String? = null,
    public val destinationAddresses: List<String>? = null,
    public val fqdnTags: List<String>? = null,
    public val name: String? = null,
    public val protocols: List<FirewallPolicyRuleConditionApplicationProtocolResponse>? = null,
    public val ruleConditionType: String,
    public val sourceAddresses: List<String>? = null,
    public val sourceIpGroups: List<String>? = null,
    public val targetFqdns: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationRuleConditionResponse):
            ApplicationRuleConditionResponse = ApplicationRuleConditionResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinationAddresses = javaType.destinationAddresses().map({ args0 -> args0 }),
            fqdnTags = javaType.fqdnTags().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            protocols = javaType.protocols().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyRuleConditionApplicationProtocolResponse.Companion.toKotlin(args0)
                })
            }),
            ruleConditionType = javaType.ruleConditionType(),
            sourceAddresses = javaType.sourceAddresses().map({ args0 -> args0 }),
            sourceIpGroups = javaType.sourceIpGroups().map({ args0 -> args0 }),
            targetFqdns = javaType.targetFqdns().map({ args0 -> args0 }),
        )
    }
}
