@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Rule of type application.
 * @property description Description of the rule.
 * @property destinationAddresses List of destination IP addresses or Service Tags.
 * @property fqdnTags List of FQDN Tags for this rule.
 * @property httpHeadersToInsert List of HTTP/S headers to insert.
 * @property name Name of the rule.
 * @property protocols Array of Application Protocols.
 * @property ruleType Rule Type.
 * Expected value is 'ApplicationRule'.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 * @property targetFqdns List of FQDNs for this rule.
 * @property targetUrls List of Urls for this rule condition.
 * @property terminateTLS Terminate TLS connections for this rule.
 * @property webCategories List of destination azure web categories.
 */
public data class ApplicationRuleResponse(
    public val description: String? = null,
    public val destinationAddresses: List<String>? = null,
    public val fqdnTags: List<String>? = null,
    public val httpHeadersToInsert: List<FirewallPolicyHttpHeaderToInsertResponse>? = null,
    public val name: String? = null,
    public val protocols: List<FirewallPolicyRuleApplicationProtocolResponse>? = null,
    public val ruleType: String,
    public val sourceAddresses: List<String>? = null,
    public val sourceIpGroups: List<String>? = null,
    public val targetFqdns: List<String>? = null,
    public val targetUrls: List<String>? = null,
    public val terminateTLS: Boolean? = null,
    public val webCategories: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationRuleResponse):
            ApplicationRuleResponse = ApplicationRuleResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinationAddresses = javaType.destinationAddresses().map({ args0 -> args0 }),
            fqdnTags = javaType.fqdnTags().map({ args0 -> args0 }),
            httpHeadersToInsert = javaType.httpHeadersToInsert().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyHttpHeaderToInsertResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            protocols = javaType.protocols().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyRuleApplicationProtocolResponse.Companion.toKotlin(args0)
                })
            }),
            ruleType = javaType.ruleType(),
            sourceAddresses = javaType.sourceAddresses().map({ args0 -> args0 }),
            sourceIpGroups = javaType.sourceIpGroups().map({ args0 -> args0 }),
            targetFqdns = javaType.targetFqdns().map({ args0 -> args0 }),
            targetUrls = javaType.targetUrls().map({ args0 -> args0 }),
            terminateTLS = javaType.terminateTLS().map({ args0 -> args0 }).orElse(null),
            webCategories = javaType.webCategories().map({ args0 -> args0 }),
        )
    }
}
