@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Settings that apply to all backend pools.
 * @property enforceCertificateNameCheck Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
 * @property sendRecvTimeoutSeconds Send and receive timeout on forwarding request to the backend. When timeout is reached, the request fails and returns.
 */
public data class BackendPoolsSettingsResponse(
    public val enforceCertificateNameCheck: String? = null,
    public val sendRecvTimeoutSeconds: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.BackendPoolsSettingsResponse):
            BackendPoolsSettingsResponse = BackendPoolsSettingsResponse(
            enforceCertificateNameCheck = javaType.enforceCertificateNameCheck().map({ args0 ->
                args0
            }).orElse(null),
            sendRecvTimeoutSeconds = javaType.sendRecvTimeoutSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
