@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Backend address of a frontDoor load balancer.
 * @property address Location of the backend (IP address or FQDN)
 * @property backendHostHeader The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
 * @property enabledState Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
 * @property httpPort The HTTP TCP port number. Must be between 1 and 65535.
 * @property httpsPort The HTTPS TCP port number. Must be between 1 and 65535.
 * @property priority Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy.
 * @property privateEndpointStatus The Approval status for the connection to the Private Link
 * @property privateLinkAlias The Alias of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
 * @property privateLinkApprovalMessage A custom message to be included in the approval request to connect to the Private Link
 * @property privateLinkLocation The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
 * @property privateLinkResourceId The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
 * @property weight Weight of this endpoint for load balancing purposes.
 */
public data class BackendResponse(
    public val address: String? = null,
    public val backendHostHeader: String? = null,
    public val enabledState: String? = null,
    public val httpPort: Int? = null,
    public val httpsPort: Int? = null,
    public val priority: Int? = null,
    public val privateEndpointStatus: String,
    public val privateLinkAlias: String? = null,
    public val privateLinkApprovalMessage: String? = null,
    public val privateLinkLocation: String? = null,
    public val privateLinkResourceId: String? = null,
    public val weight: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.BackendResponse):
            BackendResponse = BackendResponse(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            backendHostHeader = javaType.backendHostHeader().map({ args0 -> args0 }).orElse(null),
            enabledState = javaType.enabledState().map({ args0 -> args0 }).orElse(null),
            httpPort = javaType.httpPort().map({ args0 -> args0 }).orElse(null),
            httpsPort = javaType.httpsPort().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            privateEndpointStatus = javaType.privateEndpointStatus(),
            privateLinkAlias = javaType.privateLinkAlias().map({ args0 -> args0 }).orElse(null),
            privateLinkApprovalMessage = javaType.privateLinkApprovalMessage().map({ args0 ->
                args0
            }).orElse(null),
            privateLinkLocation = javaType.privateLinkLocation().map({ args0 -> args0 }).orElse(null),
            privateLinkResourceId = javaType.privateLinkResourceId().map({ args0 -> args0 }).orElse(null),
            weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
