@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * BGP peer status details.
 * @property asn The autonomous system number of the remote BGP peer.
 * @property connectedDuration For how long the peering has been up.
 * @property localAddress The virtual network gateway's local address.
 * @property messagesReceived The number of BGP messages received.
 * @property messagesSent The number of BGP messages sent.
 * @property neighbor The remote BGP peer.
 * @property routesReceived The number of routes learned from this peer.
 * @property state The BGP peer state.
 */
public data class BgpPeerStatusResponse(
    public val asn: Double,
    public val connectedDuration: String,
    public val localAddress: String,
    public val messagesReceived: Double,
    public val messagesSent: Double,
    public val neighbor: String,
    public val routesReceived: Double,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.BgpPeerStatusResponse):
            BgpPeerStatusResponse = BgpPeerStatusResponse(
            asn = javaType.asn(),
            connectedDuration = javaType.connectedDuration(),
            localAddress = javaType.localAddress(),
            messagesReceived = javaType.messagesReceived(),
            messagesSent = javaType.messagesSent(),
            neighbor = javaType.neighbor(),
            routesReceived = javaType.routesReceived(),
            state = javaType.state(),
        )
    }
}
