@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Network Virtual Appliance Sku Properties.
 * @property allow Flag to control breakout of o365 allow category.
 * @property default Flag to control breakout of o365 default category.
 * @property optimize Flag to control breakout of o365 optimize category.
 */
public data class BreakOutCategoryPoliciesResponse(
    public val allow: Boolean? = null,
    public val default: Boolean? = null,
    public val optimize: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.BreakOutCategoryPoliciesResponse):
            BreakOutCategoryPoliciesResponse = BreakOutCategoryPoliciesResponse(
            allow = javaType.allow().map({ args0 -> args0 }).orElse(null),
            default = javaType.default_().map({ args0 -> args0 }).orElse(null),
            optimize = javaType.optimize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
