@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes the connection monitor endpoint scope.
 * @property exclude List of items which needs to be excluded from the endpoint scope.
 * @property include List of items which needs to be included to the endpoint scope.
 */
public data class ConnectionMonitorEndpointScopeResponse(
    public val exclude: List<ConnectionMonitorEndpointScopeItemResponse>? = null,
    public val include: List<ConnectionMonitorEndpointScopeItemResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ConnectionMonitorEndpointScopeResponse):
            ConnectionMonitorEndpointScopeResponse = ConnectionMonitorEndpointScopeResponse(
            exclude = javaType.exclude().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorEndpointScopeItemResponse.Companion.toKotlin(args0)
                })
            }),
            include = javaType.include().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorEndpointScopeItemResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
