@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines contents of a web application rule
 * @property action Describes what action to be applied when rule matches.
 * @property enabledState Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
 * @property matchConditions List of match conditions.
 * @property name Describes the name of the rule.
 * @property priority Describes priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
 * @property rateLimitDurationInMinutes Time window for resetting the rate limit count. Default is 1 minute.
 * @property rateLimitThreshold Number of allowed requests per client within the time window.
 * @property ruleType Describes type of rule.
 */
public data class CustomRuleResponse(
    public val action: String,
    public val enabledState: String? = null,
    public val matchConditions: List<FrontDoorMatchConditionResponse>,
    public val name: String? = null,
    public val priority: Int,
    public val rateLimitDurationInMinutes: Int? = null,
    public val rateLimitThreshold: Int? = null,
    public val ruleType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.CustomRuleResponse):
            CustomRuleResponse = CustomRuleResponse(
            action = javaType.action(),
            enabledState = javaType.enabledState().map({ args0 -> args0 }).orElse(null),
            matchConditions = javaType.matchConditions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FrontDoorMatchConditionResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority(),
            rateLimitDurationInMinutes = javaType.rateLimitDurationInMinutes().map({ args0 ->
                args0
            }).orElse(null),
            rateLimitThreshold = javaType.rateLimitThreshold().map({ args0 -> args0 }).orElse(null),
            ruleType = javaType.ruleType(),
        )
    }
}
