@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines a managed rule set for Exclusions.
 * @property ruleGroups Defines the rule groups to apply to the rule set.
 * @property ruleSetType Defines the rule set type to use.
 * @property ruleSetVersion Defines the version of the rule set to use.
 */
public data class ExclusionManagedRuleSetResponse(
    public val ruleGroups: List<ExclusionManagedRuleGroupResponse>? = null,
    public val ruleSetType: String,
    public val ruleSetVersion: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ExclusionManagedRuleSetResponse):
            ExclusionManagedRuleSetResponse = ExclusionManagedRuleSetResponse(
            ruleGroups = javaType.ruleGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExclusionManagedRuleGroupResponse.Companion.toKotlin(args0)
                })
            }),
            ruleSetType = javaType.ruleSetType(),
            ruleSetVersion = javaType.ruleSetVersion(),
        )
    }
}
