@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * Contains stats associated with the peering.
 * @property primarybytesIn The Primary BytesIn of the peering.
 * @property primarybytesOut The primary BytesOut of the peering.
 * @property secondarybytesIn The secondary BytesIn of the peering.
 * @property secondarybytesOut The secondary BytesOut of the peering.
 */
public data class ExpressRouteCircuitStatsResponse(
    public val primarybytesIn: Double? = null,
    public val primarybytesOut: Double? = null,
    public val secondarybytesIn: Double? = null,
    public val secondarybytesOut: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ExpressRouteCircuitStatsResponse):
            ExpressRouteCircuitStatsResponse = ExpressRouteCircuitStatsResponse(
            primarybytesIn = javaType.primarybytesIn().map({ args0 -> args0 }).orElse(null),
            primarybytesOut = javaType.primarybytesOut().map({ args0 -> args0 }).orElse(null),
            secondarybytesIn = javaType.secondarybytesIn().map({ args0 -> args0 }).orElse(null),
            secondarybytesOut = javaType.secondarybytesOut().map({ args0 -> args0 }).orElse(null),
        )
    }
}
