@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration for intrusion detection mode and rules.
 * @property configuration Intrusion detection configuration properties.
 * @property mode Intrusion detection general state. When attached to a parent policy, the firewall's effective IDPS mode is the stricter mode of the two.
 * @property profile IDPS profile name. When attached to a parent policy, the firewall's effective profile is the profile name of the parent policy.
 */
public data class FirewallPolicyIntrusionDetectionResponse(
    public val configuration: FirewallPolicyIntrusionDetectionConfigurationResponse? = null,
    public val mode: String? = null,
    public val profile: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicyIntrusionDetectionResponse):
            FirewallPolicyIntrusionDetectionResponse = FirewallPolicyIntrusionDetectionResponse(
            configuration = javaType.configuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyIntrusionDetectionConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            profile = javaType.profile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
