@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Log Analytics Resources for Firewall Policy Insights.
 * @property defaultWorkspaceId The default workspace Id for Firewall Policy Insights.
 * @property workspaces List of workspaces for Firewall Policy Insights.
 */
public data class FirewallPolicyLogAnalyticsResourcesResponse(
    public val defaultWorkspaceId: SubResourceResponse? = null,
    public val workspaces: List<FirewallPolicyLogAnalyticsWorkspaceResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicyLogAnalyticsResourcesResponse):
            FirewallPolicyLogAnalyticsResourcesResponse = FirewallPolicyLogAnalyticsResourcesResponse(
            defaultWorkspaceId = javaType.defaultWorkspaceId().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            workspaces = javaType.workspaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyLogAnalyticsWorkspaceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
