@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * ThreatIntel Whitelist for Firewall Policy.
 * @property fqdns List of FQDNs for the ThreatIntel Whitelist.
 * @property ipAddresses List of IP addresses for the ThreatIntel Whitelist.
 */
public data class FirewallPolicyThreatIntelWhitelistResponse(
    public val fqdns: List<String>? = null,
    public val ipAddresses: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicyThreatIntelWhitelistResponse):
            FirewallPolicyThreatIntelWhitelistResponse = FirewallPolicyThreatIntelWhitelistResponse(
            fqdns = javaType.fqdns().map({ args0 -> args0 }),
            ipAddresses = javaType.ipAddresses().map({ args0 -> args0 }),
        )
    }
}
