@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Private Endpoint connection on an application gateway.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property linkIdentifier The consumer link id.
 * @property name Name of the private endpoint connection on an application gateway.
 * @property privateEndpoint The resource of private end point.
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property provisioningState The provisioning state of the application gateway private endpoint connection resource.
 * @property type Type of the resource.
 */
public data class GetApplicationGatewayPrivateEndpointConnectionResult(
    public val etag: String,
    public val id: String? = null,
    public val linkIdentifier: String,
    public val name: String? = null,
    public val privateEndpoint: PrivateEndpointResponse,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetApplicationGatewayPrivateEndpointConnectionResult):
            GetApplicationGatewayPrivateEndpointConnectionResult =
            GetApplicationGatewayPrivateEndpointConnectionResult(
                etag = javaType.etag(),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                linkIdentifier = javaType.linkIdentifier(),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                privateEndpoint = javaType.privateEndpoint().let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
                }),
                privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                provisioningState = javaType.provisioningState(),
                type = javaType.type(),
            )
    }
}
