@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * FirewallPolicy Resource.
 * @property basePolicy The parent firewall policy from which rules are inherited.
 * @property dnsSettings DNS Proxy Settings definition.
 * @property explicitProxy Explicit Proxy Settings definition.
 * @property id Resource ID.
 * @property insights Insights on Firewall Policy.
 * @property intrusionDetection The configuration for Intrusion detection.
 * @property location Resource location.
 * @property name Resource name.
 * @property snat The private IP addresses/IP ranges to which traffic will not be SNAT.
 * @property sql SQL Settings definition.
 * @property tags Resource tags.
 * @property threatIntelMode The operation mode for Threat Intelligence.
 * @property threatIntelWhitelist ThreatIntel Whitelist for Firewall Policy.
 * @property type Resource type.
 */
public data class GetFirewallPolicyDraftResult(
    public val basePolicy: SubResourceResponse? = null,
    public val dnsSettings: DnsSettingsResponse? = null,
    public val explicitProxy: ExplicitProxyResponse? = null,
    public val id: String? = null,
    public val insights: FirewallPolicyInsightsResponse? = null,
    public val intrusionDetection: FirewallPolicyIntrusionDetectionResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val snat: FirewallPolicySNATResponse? = null,
    public val sql: FirewallPolicySQLResponse? = null,
    public val tags: Map<String, String>? = null,
    public val threatIntelMode: String? = null,
    public val threatIntelWhitelist: FirewallPolicyThreatIntelWhitelistResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetFirewallPolicyDraftResult):
            GetFirewallPolicyDraftResult = GetFirewallPolicyDraftResult(
            basePolicy = javaType.basePolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dnsSettings = javaType.dnsSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.DnsSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            explicitProxy = javaType.explicitProxy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExplicitProxyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            insights = javaType.insights().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyInsightsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            intrusionDetection = javaType.intrusionDetection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyIntrusionDetectionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            snat = javaType.snat().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicySNATResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sql = javaType.sql().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicySQLResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            threatIntelMode = javaType.threatIntelMode().map({ args0 -> args0 }).orElse(null),
            threatIntelWhitelist = javaType.threatIntelWhitelist().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyThreatIntelWhitelistResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
