@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * IpAllocation resource.
 * @property allocationTags IpAllocation tags.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property ipamAllocationId The IPAM allocation ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property prefix The address prefix for the IpAllocation.
 * @property prefixLength The address prefix length for the IpAllocation.
 * @property prefixType The address prefix Type for the IpAllocation.
 * @property subnet The Subnet that using the prefix of this IpAllocation resource.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property virtualNetwork The VirtualNetwork that using the prefix of this IpAllocation resource.
 */
public data class GetIpAllocationResult(
    public val allocationTags: Map<String, String>? = null,
    public val etag: String,
    public val id: String? = null,
    public val ipamAllocationId: String? = null,
    public val location: String? = null,
    public val name: String,
    public val prefix: String? = null,
    public val prefixLength: Int? = null,
    public val prefixType: String? = null,
    public val subnet: SubResourceResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualNetwork: SubResourceResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetIpAllocationResult):
            GetIpAllocationResult = GetIpAllocationResult(
            allocationTags = javaType.allocationTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipamAllocationId = javaType.ipamAllocationId().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            prefixLength = javaType.prefixLength().map({ args0 -> args0 }).orElse(null),
            prefixType = javaType.prefixType().map({ args0 -> args0 }).orElse(null),
            subnet = javaType.subnet().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualNetwork = javaType.virtualNetwork().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
