@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Information about packet capture session.
 * @property bytesToCapturePerPacket Number of bytes captured per packet, the remaining bytes are truncated.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property filters A list of packet capture filters.
 * @property id ID of the packet capture operation.
 * @property name Name of the packet capture session.
 * @property provisioningState The provisioning state of the packet capture session.
 * @property scope A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and excluded are empty, then the packet capture will run on all instances of AzureVMSS.
 * @property storageLocation The storage location for a packet capture session.
 * @property target The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently supported.
 * @property targetType Target type of the resource provided.
 * @property timeLimitInSeconds Maximum duration of the capture session in seconds.
 * @property totalBytesPerSession Maximum size of the capture output.
 */
public data class GetPacketCaptureResult(
    public val bytesToCapturePerPacket: Double? = null,
    public val etag: String,
    public val filters: List<PacketCaptureFilterResponse>? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val scope: PacketCaptureMachineScopeResponse? = null,
    public val storageLocation: PacketCaptureStorageLocationResponse,
    public val target: String,
    public val targetType: String? = null,
    public val timeLimitInSeconds: Int? = null,
    public val totalBytesPerSession: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetPacketCaptureResult):
            GetPacketCaptureResult = GetPacketCaptureResult(
            bytesToCapturePerPacket = javaType.bytesToCapturePerPacket().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PacketCaptureFilterResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            scope = javaType.scope().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PacketCaptureMachineScopeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageLocation = javaType.storageLocation().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.PacketCaptureStorageLocationResponse.Companion.toKotlin(args0)
            }),
            target = javaType.target(),
            targetType = javaType.targetType().map({ args0 -> args0 }).orElse(null),
            timeLimitInSeconds = javaType.timeLimitInSeconds().map({ args0 -> args0 }).orElse(null),
            totalBytesPerSession = javaType.totalBytesPerSession().map({ args0 -> args0 }).orElse(null),
        )
    }
}
