@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Private link service resource.
 * @property alias The alias of the private link service.
 * @property autoApproval The auto-approval list of the private link service.
 * @property enableProxyProtocol Whether the private link service is enabled for proxy protocol or not.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property extendedLocation The extended location of the load balancer.
 * @property fqdns The list of Fqdn.
 * @property id Resource ID.
 * @property ipConfigurations An array of private link service IP configurations.
 * @property loadBalancerFrontendIpConfigurations An array of references to the load balancer IP configurations.
 * @property location Resource location.
 * @property name Resource name.
 * @property networkInterfaces An array of references to the network interfaces created for this private link service.
 * @property privateEndpointConnections An array of list about connections to the private endpoint.
 * @property provisioningState The provisioning state of the private link service resource.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property visibility The visibility list of the private link service.
 */
public data class GetPrivateLinkServiceResult(
    public val alias: String,
    public val autoApproval: PrivateLinkServicePropertiesResponseAutoApproval? = null,
    public val enableProxyProtocol: Boolean? = null,
    public val etag: String,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val fqdns: List<String>? = null,
    public val id: String? = null,
    public val ipConfigurations: List<PrivateLinkServiceIpConfigurationResponse>? = null,
    public val loadBalancerFrontendIpConfigurations: List<FrontendIPConfigurationResponse>? = null,
    public val location: String? = null,
    public val name: String,
    public val networkInterfaces: List<NetworkInterfaceResponse>,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val visibility: PrivateLinkServicePropertiesResponseVisibility? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetPrivateLinkServiceResult):
            GetPrivateLinkServiceResult = GetPrivateLinkServiceResult(
            alias = javaType.alias(),
            autoApproval = javaType.autoApproval().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServicePropertiesResponseAutoApproval.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enableProxyProtocol = javaType.enableProxyProtocol().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fqdns = javaType.fqdns().map({ args0 -> args0 }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipConfigurations = javaType.ipConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServiceIpConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            loadBalancerFrontendIpConfigurations = javaType.loadBalancerFrontendIpConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FrontendIPConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkInterfaces = javaType.networkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceResponse.Companion.toKotlin(args0)
                })
            }),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            visibility = javaType.visibility().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServicePropertiesResponseVisibility.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
