@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Describes a Private DNS zone.
 * @property etag The ETag of the zone.
 * @property id Fully qualified resource Id for the resource. Example - '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateDnsZoneName}'.
 * @property internalId Private zone internal Id
 * @property location The Azure Region where the resource lives
 * @property maxNumberOfRecordSets The maximum number of record sets that can be created in this Private DNS zone. This is a read-only property and any attempt to set this value will be ignored.
 * @property maxNumberOfVirtualNetworkLinks The maximum number of virtual networks that can be linked to this Private DNS zone. This is a read-only property and any attempt to set this value will be ignored.
 * @property maxNumberOfVirtualNetworkLinksWithRegistration The maximum number of virtual networks that can be linked to this Private DNS zone with registration enabled. This is a read-only property and any attempt to set this value will be ignored.
 * @property name The name of the resource
 * @property numberOfRecordSets The current number of record sets in this Private DNS zone. This is a read-only property and any attempt to set this value will be ignored.
 * @property numberOfVirtualNetworkLinks The current number of virtual networks that are linked to this Private DNS zone. This is a read-only property and any attempt to set this value will be ignored.
 * @property numberOfVirtualNetworkLinksWithRegistration The current number of virtual networks that are linked to this Private DNS zone with registration enabled. This is a read-only property and any attempt to set this value will be ignored.
 * @property provisioningState The provisioning state of the resource. This is a read-only property and any attempt to set this value will be ignored.
 * @property tags Resource tags.
 * @property type The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
 */
public data class GetPrivateZoneResult(
    public val etag: String? = null,
    public val id: String,
    public val internalId: String,
    public val location: String? = null,
    public val maxNumberOfRecordSets: Double,
    public val maxNumberOfVirtualNetworkLinks: Double,
    public val maxNumberOfVirtualNetworkLinksWithRegistration: Double,
    public val name: String,
    public val numberOfRecordSets: Double,
    public val numberOfVirtualNetworkLinks: Double,
    public val numberOfVirtualNetworkLinksWithRegistration: Double,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetPrivateZoneResult):
            GetPrivateZoneResult = GetPrivateZoneResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            internalId = javaType.internalId(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            maxNumberOfRecordSets = javaType.maxNumberOfRecordSets(),
            maxNumberOfVirtualNetworkLinks = javaType.maxNumberOfVirtualNetworkLinks(),
            maxNumberOfVirtualNetworkLinksWithRegistration = javaType.maxNumberOfVirtualNetworkLinksWithRegistration(),
            name = javaType.name(),
            numberOfRecordSets = javaType.numberOfRecordSets(),
            numberOfVirtualNetworkLinks = javaType.numberOfVirtualNetworkLinks(),
            numberOfVirtualNetworkLinksWithRegistration = javaType.numberOfVirtualNetworkLinksWithRegistration(),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
