@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The RouteMap child resource of a Virtual hub.
 * @property associatedInboundConnections List of connections which have this RoutMap associated for inbound traffic.
 * @property associatedOutboundConnections List of connections which have this RoutMap associated for outbound traffic.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the RouteMap resource.
 * @property rules List of RouteMap rules to be applied.
 * @property type Resource type.
 */
public data class GetRouteMapResult(
    public val associatedInboundConnections: List<String>? = null,
    public val associatedOutboundConnections: List<String>? = null,
    public val etag: String,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val rules: List<RouteMapRuleResponse>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetRouteMapResult):
            GetRouteMapResult = GetRouteMapResult(
            associatedInboundConnections = javaType.associatedInboundConnections().map({ args0 -> args0 }),
            associatedOutboundConnections = javaType.associatedOutboundConnections().map({ args0 -> args0 }),
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RouteMapRuleResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
