@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the security user configuration
 * @property deleteExistingNSGs Flag if need to delete existing network security groups.
 * @property description A description of the security user configuration.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the resource.
 * @property systemData The system metadata related to this resource.
 * @property type Resource type.
 */
public data class GetSecurityUserConfigurationResult(
    public val deleteExistingNSGs: String? = null,
    public val description: String? = null,
    public val etag: String,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetSecurityUserConfigurationResult):
            GetSecurityUserConfigurationResult = GetSecurityUserConfigurationResult(
            deleteExistingNSGs = javaType.deleteExistingNSGs().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
