@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class representing Traffic Manager User Metrics.
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
 * @property key The key returned by the User Metrics operation.
 * @property name The name of the resource
 * @property type The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
 */
public data class GetTrafficManagerUserMetricsKeyResult(
    public val id: String? = null,
    public val key: String? = null,
    public val name: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetTrafficManagerUserMetricsKeyResult):
            GetTrafficManagerUserMetricsKeyResult = GetTrafficManagerUserMetricsKeyResult(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
