@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Virtual Appliance Site resource.
 * @property addressPrefix Address Prefix.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Name of the virtual appliance site.
 * @property o365Policy Office 365 Policy.
 * @property provisioningState The provisioning state of the resource.
 * @property type Site type.
 */
public data class GetVirtualApplianceSiteResult(
    public val addressPrefix: String? = null,
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val o365Policy: Office365PolicyPropertiesResponse? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetVirtualApplianceSiteResult):
            GetVirtualApplianceSiteResult = GetVirtualApplianceSiteResult(
            addressPrefix = javaType.addressPrefix().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            o365Policy = javaType.o365Policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.Office365PolicyPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
