@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IpConfigurations.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Name of the Ip Configuration.
 * @property privateIPAddress The private IP address of the IP configuration.
 * @property privateIPAllocationMethod The private IP address allocation method.
 * @property provisioningState The provisioning state of the IP configuration resource.
 * @property publicIPAddress The reference to the public IP resource.
 * @property subnet The reference to the subnet resource.
 * @property type Ipconfiguration type.
 */
public data class GetVirtualHubIpConfigurationResult(
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val privateIPAddress: String? = null,
    public val privateIPAllocationMethod: String? = null,
    public val provisioningState: String,
    public val publicIPAddress: PublicIPAddressResponse? = null,
    public val subnet: SubnetResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetVirtualHubIpConfigurationResult):
            GetVirtualHubIpConfigurationResult = GetVirtualHubIpConfigurationResult(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            privateIPAddress = javaType.privateIPAddress().map({ args0 -> args0 }).orElse(null),
            privateIPAllocationMethod = javaType.privateIPAllocationMethod().map({ args0 ->
                args0
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publicIPAddress = javaType.publicIPAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PublicIPAddressResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
