@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * VirtualHub Resource.
 * @property addressPrefix Address-prefix for this VirtualHub.
 * @property allowBranchToBranchTraffic Flag to control transit for VirtualRouter hub.
 * @property azureFirewall The azureFirewall associated with this VirtualHub.
 * @property bgpConnections List of references to Bgp Connections.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property expressRouteGateway The expressRouteGateway associated with this VirtualHub.
 * @property hubRoutingPreference The hubRoutingPreference of this VirtualHub.
 * @property id Resource ID.
 * @property ipConfigurations List of references to IpConfigurations.
 * @property kind Kind of service virtual hub. This is metadata used for the Azure portal experience for Route Server.
 * @property location Resource location.
 * @property name Resource name.
 * @property p2SVpnGateway The P2SVpnGateway associated with this VirtualHub.
 * @property preferredRoutingGateway The preferred gateway to route on-prem traffic
 * @property provisioningState The provisioning state of the virtual hub resource.
 * @property routeMaps List of references to RouteMaps.
 * @property routeTable The routeTable associated with this virtual hub.
 * @property routingState The routing state.
 * @property securityPartnerProvider The securityPartnerProvider associated with this VirtualHub.
 * @property securityProviderName The Security Provider name.
 * @property sku The sku of this VirtualHub.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property virtualHubRouteTableV2s List of all virtual hub route table v2s associated with this VirtualHub.
 * @property virtualRouterAsn VirtualRouter ASN.
 * @property virtualRouterAutoScaleConfiguration The VirtualHub Router autoscale configuration.
 * @property virtualRouterIps VirtualRouter IPs.
 * @property virtualWan The VirtualWAN to which the VirtualHub belongs.
 * @property vpnGateway The VpnGateway associated with this VirtualHub.
 */
public data class GetVirtualHubResult(
    public val addressPrefix: String? = null,
    public val allowBranchToBranchTraffic: Boolean? = null,
    public val azureFirewall: SubResourceResponse? = null,
    public val bgpConnections: List<SubResourceResponse>,
    public val etag: String,
    public val expressRouteGateway: SubResourceResponse? = null,
    public val hubRoutingPreference: String? = null,
    public val id: String? = null,
    public val ipConfigurations: List<SubResourceResponse>,
    public val kind: String,
    public val location: String,
    public val name: String,
    public val p2SVpnGateway: SubResourceResponse? = null,
    public val preferredRoutingGateway: String? = null,
    public val provisioningState: String,
    public val routeMaps: List<SubResourceResponse>,
    public val routeTable: VirtualHubRouteTableResponse? = null,
    public val routingState: String,
    public val securityPartnerProvider: SubResourceResponse? = null,
    public val securityProviderName: String? = null,
    public val sku: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualHubRouteTableV2s: List<VirtualHubRouteTableV2Response>? = null,
    public val virtualRouterAsn: Double? = null,
    public val virtualRouterAutoScaleConfiguration: VirtualRouterAutoScaleConfigurationResponse? =
        null,
    public val virtualRouterIps: List<String>? = null,
    public val virtualWan: SubResourceResponse? = null,
    public val vpnGateway: SubResourceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetVirtualHubResult):
            GetVirtualHubResult = GetVirtualHubResult(
            addressPrefix = javaType.addressPrefix().map({ args0 -> args0 }).orElse(null),
            allowBranchToBranchTraffic = javaType.allowBranchToBranchTraffic().map({ args0 ->
                args0
            }).orElse(null),
            azureFirewall = javaType.azureFirewall().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            bgpConnections = javaType.bgpConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            expressRouteGateway = javaType.expressRouteGateway().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hubRoutingPreference = javaType.hubRoutingPreference().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipConfigurations = javaType.ipConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            kind = javaType.kind(),
            location = javaType.location(),
            name = javaType.name(),
            p2SVpnGateway = javaType.p2SVpnGateway().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            preferredRoutingGateway = javaType.preferredRoutingGateway().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            routeMaps = javaType.routeMaps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            routeTable = javaType.routeTable().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualHubRouteTableResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            routingState = javaType.routingState(),
            securityPartnerProvider = javaType.securityPartnerProvider().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            securityProviderName = javaType.securityProviderName().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualHubRouteTableV2s = javaType.virtualHubRouteTableV2s().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualHubRouteTableV2Response.Companion.toKotlin(args0)
                })
            }),
            virtualRouterAsn = javaType.virtualRouterAsn().map({ args0 -> args0 }).orElse(null),
            virtualRouterAutoScaleConfiguration = javaType.virtualRouterAutoScaleConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualRouterAutoScaleConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            virtualRouterIps = javaType.virtualRouterIps().map({ args0 -> args0 }),
            virtualWan = javaType.virtualWan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vpnGateway = javaType.vpnGateway().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
