@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * VpnConnection Resource.
 * @property connectionBandwidth Expected bandwidth in MBPS.
 * @property connectionStatus The connection status.
 * @property dpdTimeoutSeconds DPD timeout in seconds for vpn connection.
 * @property egressBytesTransferred Egress bytes transferred.
 * @property enableBgp EnableBgp flag.
 * @property enableInternetSecurity Enable internet security.
 * @property enableRateLimiting EnableBgp flag.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property ingressBytesTransferred Ingress bytes transferred.
 * @property ipsecPolicies The IPSec Policies to be considered by this connection.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the VPN connection resource.
 * @property remoteVpnSite Id of the connected vpn site.
 * @property routingConfiguration The Routing Configuration indicating the associated and propagated route tables on this connection.
 * @property routingWeight Routing weight for vpn connection.
 * @property sharedKey SharedKey for the vpn connection.
 * @property trafficSelectorPolicies The Traffic Selector Policies to be considered by this connection.
 * @property useLocalAzureIpAddress Use local azure ip to initiate connection.
 * @property usePolicyBasedTrafficSelectors Enable policy-based traffic selectors.
 * @property vpnConnectionProtocolType Connection protocol used for this connection.
 * @property vpnLinkConnections List of all vpn site link connections to the gateway.
 */
public data class GetVpnConnectionResult(
    public val connectionBandwidth: Int? = null,
    public val connectionStatus: String,
    public val dpdTimeoutSeconds: Int? = null,
    public val egressBytesTransferred: Double,
    public val enableBgp: Boolean? = null,
    public val enableInternetSecurity: Boolean? = null,
    public val enableRateLimiting: Boolean? = null,
    public val etag: String,
    public val id: String? = null,
    public val ingressBytesTransferred: Double,
    public val ipsecPolicies: List<IpsecPolicyResponse>? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val remoteVpnSite: SubResourceResponse? = null,
    public val routingConfiguration: RoutingConfigurationResponse? = null,
    public val routingWeight: Int? = null,
    public val sharedKey: String? = null,
    public val trafficSelectorPolicies: List<TrafficSelectorPolicyResponse>? = null,
    public val useLocalAzureIpAddress: Boolean? = null,
    public val usePolicyBasedTrafficSelectors: Boolean? = null,
    public val vpnConnectionProtocolType: String? = null,
    public val vpnLinkConnections: List<VpnSiteLinkConnectionResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetVpnConnectionResult):
            GetVpnConnectionResult = GetVpnConnectionResult(
            connectionBandwidth = javaType.connectionBandwidth().map({ args0 -> args0 }).orElse(null),
            connectionStatus = javaType.connectionStatus(),
            dpdTimeoutSeconds = javaType.dpdTimeoutSeconds().map({ args0 -> args0 }).orElse(null),
            egressBytesTransferred = javaType.egressBytesTransferred(),
            enableBgp = javaType.enableBgp().map({ args0 -> args0 }).orElse(null),
            enableInternetSecurity = javaType.enableInternetSecurity().map({ args0 -> args0 }).orElse(null),
            enableRateLimiting = javaType.enableRateLimiting().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ingressBytesTransferred = javaType.ingressBytesTransferred(),
            ipsecPolicies = javaType.ipsecPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.IpsecPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            remoteVpnSite = javaType.remoteVpnSite().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            routingConfiguration = javaType.routingConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RoutingConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            routingWeight = javaType.routingWeight().map({ args0 -> args0 }).orElse(null),
            sharedKey = javaType.sharedKey().map({ args0 -> args0 }).orElse(null),
            trafficSelectorPolicies = javaType.trafficSelectorPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.TrafficSelectorPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            useLocalAzureIpAddress = javaType.useLocalAzureIpAddress().map({ args0 -> args0 }).orElse(null),
            usePolicyBasedTrafficSelectors = javaType.usePolicyBasedTrafficSelectors().map({ args0 ->
                args0
            }).orElse(null),
            vpnConnectionProtocolType = javaType.vpnConnectionProtocolType().map({ args0 ->
                args0
            }).orElse(null),
            vpnLinkConnections = javaType.vpnLinkConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnSiteLinkConnectionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
