@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * VpnServerConfiguration Resource.
 * @property aadAuthenticationParameters The set of aad vpn authentication parameters.
 * @property configurationPolicyGroups List of all VpnServerConfigurationPolicyGroups.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property p2SVpnGateways List of references to P2SVpnGateways.
 * @property provisioningState The provisioning state of the VpnServerConfiguration resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
 * @property radiusClientRootCertificates Radius client root certificate of VpnServerConfiguration.
 * @property radiusServerAddress The radius server address property of the VpnServerConfiguration resource for point to site client connection.
 * @property radiusServerRootCertificates Radius Server root certificate of VpnServerConfiguration.
 * @property radiusServerSecret The radius secret property of the VpnServerConfiguration resource for point to site client connection.
 * @property radiusServers Multiple Radius Server configuration for VpnServerConfiguration.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property vpnAuthenticationTypes VPN authentication types for the VpnServerConfiguration.
 * @property vpnClientIpsecPolicies VpnClientIpsecPolicies for VpnServerConfiguration.
 * @property vpnClientRevokedCertificates VPN client revoked certificate of VpnServerConfiguration.
 * @property vpnClientRootCertificates VPN client root certificate of VpnServerConfiguration.
 * @property vpnProtocols VPN protocols for the VpnServerConfiguration.
 */
public data class GetVpnServerConfigurationResult(
    public val aadAuthenticationParameters: AadAuthenticationParametersResponse? = null,
    public val configurationPolicyGroups: List<VpnServerConfigurationPolicyGroupResponse>? = null,
    public val etag: String,
    public val id: String? = null,
    public val location: String? = null,
    public val name: String,
    public val p2SVpnGateways: List<P2SVpnGatewayResponse>,
    public val provisioningState: String,
    public val radiusClientRootCertificates: List<VpnServerConfigRadiusClientRootCertificateResponse>? =
        null,
    public val radiusServerAddress: String? = null,
    public val radiusServerRootCertificates: List<VpnServerConfigRadiusServerRootCertificateResponse>? =
        null,
    public val radiusServerSecret: String? = null,
    public val radiusServers: List<RadiusServerResponse>? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vpnAuthenticationTypes: List<String>? = null,
    public val vpnClientIpsecPolicies: List<IpsecPolicyResponse>? = null,
    public val vpnClientRevokedCertificates: List<VpnServerConfigVpnClientRevokedCertificateResponse>? =
        null,
    public val vpnClientRootCertificates: List<VpnServerConfigVpnClientRootCertificateResponse>? =
        null,
    public val vpnProtocols: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetVpnServerConfigurationResult):
            GetVpnServerConfigurationResult = GetVpnServerConfigurationResult(
            aadAuthenticationParameters = javaType.aadAuthenticationParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AadAuthenticationParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            configurationPolicyGroups = javaType.configurationPolicyGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigurationPolicyGroupResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            p2SVpnGateways = javaType.p2SVpnGateways().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.P2SVpnGatewayResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            radiusClientRootCertificates = javaType.radiusClientRootCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigRadiusClientRootCertificateResponse.Companion.toKotlin(args0)
                })
            }),
            radiusServerAddress = javaType.radiusServerAddress().map({ args0 -> args0 }).orElse(null),
            radiusServerRootCertificates = javaType.radiusServerRootCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigRadiusServerRootCertificateResponse.Companion.toKotlin(args0)
                })
            }),
            radiusServerSecret = javaType.radiusServerSecret().map({ args0 -> args0 }).orElse(null),
            radiusServers = javaType.radiusServers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RadiusServerResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vpnAuthenticationTypes = javaType.vpnAuthenticationTypes().map({ args0 -> args0 }),
            vpnClientIpsecPolicies = javaType.vpnClientIpsecPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.IpsecPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            vpnClientRevokedCertificates = javaType.vpnClientRevokedCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigVpnClientRevokedCertificateResponse.Companion.toKotlin(args0)
                })
            }),
            vpnClientRootCertificates = javaType.vpnClientRootCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigVpnClientRootCertificateResponse.Companion.toKotlin(args0)
                })
            }),
            vpnProtocols = javaType.vpnProtocols().map({ args0 -> args0 }),
        )
    }
}
