@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Defines web application firewall policy.
 * @property applicationGateways A collection of references to application gateways.
 * @property customRules The custom rules inside the policy.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property httpListeners A collection of references to application gateway http listeners.
 * @property id Resource ID.
 * @property location Resource location.
 * @property managedRules Describes the managedRules structure.
 * @property name Resource name.
 * @property pathBasedRules A collection of references to application gateway path rules.
 * @property policySettings The PolicySettings for policy.
 * @property provisioningState The provisioning state of the web application firewall policy resource.
 * @property resourceState Resource status of the policy.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetWebApplicationFirewallPolicyResult(
    public val applicationGateways: List<ApplicationGatewayResponse>,
    public val customRules: List<WebApplicationFirewallCustomRuleResponse>? = null,
    public val etag: String,
    public val httpListeners: List<SubResourceResponse>,
    public val id: String? = null,
    public val location: String? = null,
    public val managedRules: ManagedRulesDefinitionResponse,
    public val name: String,
    public val pathBasedRules: List<SubResourceResponse>,
    public val policySettings: PolicySettingsResponse? = null,
    public val provisioningState: String,
    public val resourceState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetWebApplicationFirewallPolicyResult):
            GetWebApplicationFirewallPolicyResult = GetWebApplicationFirewallPolicyResult(
            applicationGateways = javaType.applicationGateways().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayResponse.Companion.toKotlin(args0)
                })
            }),
            customRules = javaType.customRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.WebApplicationFirewallCustomRuleResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            httpListeners = javaType.httpListeners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            managedRules = javaType.managedRules().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.ManagedRulesDefinitionResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            pathBasedRules = javaType.pathBasedRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            policySettings = javaType.policySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PolicySettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resourceState = javaType.resourceState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
