@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains IPv6 peering config.
 * @property microsoftPeeringConfig The Microsoft peering configuration.
 * @property primaryPeerAddressPrefix The primary address prefix.
 * @property routeFilter The reference to the RouteFilter resource.
 * @property secondaryPeerAddressPrefix The secondary address prefix.
 * @property state The state of peering.
 */
public data class Ipv6ExpressRouteCircuitPeeringConfigResponse(
    public val microsoftPeeringConfig: ExpressRouteCircuitPeeringConfigResponse? = null,
    public val primaryPeerAddressPrefix: String? = null,
    public val routeFilter: SubResourceResponse? = null,
    public val secondaryPeerAddressPrefix: String? = null,
    public val state: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.Ipv6ExpressRouteCircuitPeeringConfigResponse):
            Ipv6ExpressRouteCircuitPeeringConfigResponse = Ipv6ExpressRouteCircuitPeeringConfigResponse(
            microsoftPeeringConfig = javaType.microsoftPeeringConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitPeeringConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            primaryPeerAddressPrefix = javaType.primaryPeerAddressPrefix().map({ args0 -> args0 }).orElse(null),
            routeFilter = javaType.routeFilter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            secondaryPeerAddressPrefix = javaType.secondaryPeerAddressPrefix().map({ args0 ->
                args0
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
