@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Define match variables.
 * @property selector The selector of match variable.
 * @property variableName Match Variable.
 */
public data class MatchVariableResponse(
    public val selector: String? = null,
    public val variableName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.MatchVariableResponse):
            MatchVariableResponse = MatchVariableResponse(
            selector = javaType.selector().map({ args0 -> args0 }).orElse(null),
            variableName = javaType.variableName(),
        )
    }
}
