@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * An MX record.
 * @property exchange The domain name of the mail host for this MX record.
 * @property preference The preference value for this MX record.
 */
public data class MxRecordResponse(
    public val exchange: String? = null,
    public val preference: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.MxRecordResponse):
            MxRecordResponse = MxRecordResponse(
            exchange = javaType.exchange().map({ args0 -> args0 }).orElse(null),
            preference = javaType.preference().map({ args0 -> args0 }).orElse(null),
        )
    }
}
