@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Rule condition of type nat.
 * @property description Description of the rule condition.
 * @property destinationAddresses List of destination IP addresses or Service Tags.
 * @property destinationPorts List of destination ports.
 * @property ipProtocols Array of FirewallPolicyRuleConditionNetworkProtocols.
 * @property name Name of the rule condition.
 * @property ruleConditionType Rule Condition Type.
 * Expected value is 'NatRuleCondition'.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 */
public data class NatRuleConditionResponse(
    public val description: String? = null,
    public val destinationAddresses: List<String>? = null,
    public val destinationPorts: List<String>? = null,
    public val ipProtocols: List<String>? = null,
    public val name: String? = null,
    public val ruleConditionType: String,
    public val sourceAddresses: List<String>? = null,
    public val sourceIpGroups: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.NatRuleConditionResponse):
            NatRuleConditionResponse = NatRuleConditionResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinationAddresses = javaType.destinationAddresses().map({ args0 -> args0 }),
            destinationPorts = javaType.destinationPorts().map({ args0 -> args0 }),
            ipProtocols = javaType.ipProtocols().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            ruleConditionType = javaType.ruleConditionType(),
            sourceAddresses = javaType.sourceAddresses().map({ args0 -> args0 }),
            sourceIpGroups = javaType.sourceIpGroups().map({ args0 -> args0 }),
        )
    }
}
