@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Tap configuration in a Network Interface.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the network interface tap configuration resource.
 * @property type Sub Resource type.
 * @property virtualNetworkTap The reference to the Virtual Network Tap resource.
 */
public data class NetworkInterfaceTapConfigurationResponse(
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val type: String,
    public val virtualNetworkTap: VirtualNetworkTapResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.NetworkInterfaceTapConfigurationResponse):
            NetworkInterfaceTapConfigurationResponse = NetworkInterfaceTapConfigurationResponse(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
            virtualNetworkTap = javaType.virtualNetworkTap().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkTapResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
