@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Network Manager Deployment Status.
 * @property commitTime Commit Time.
 * @property configurationIds List of configuration ids.
 * @property deploymentStatus Deployment Status.
 * @property deploymentType Configuration Deployment Type.
 * @property errorMessage Error Message.
 * @property region Region Name.
 */
public data class NetworkManagerDeploymentStatusResponse(
    public val commitTime: String? = null,
    public val configurationIds: List<String>? = null,
    public val deploymentStatus: String? = null,
    public val deploymentType: String? = null,
    public val errorMessage: String? = null,
    public val region: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.NetworkManagerDeploymentStatusResponse):
            NetworkManagerDeploymentStatusResponse = NetworkManagerDeploymentStatusResponse(
            commitTime = javaType.commitTime().map({ args0 -> args0 }).orElse(null),
            configurationIds = javaType.configurationIds().map({ args0 -> args0 }),
            deploymentStatus = javaType.deploymentStatus().map({ args0 -> args0 }).orElse(null),
            deploymentType = javaType.deploymentType().map({ args0 -> args0 }).orElse(null),
            errorMessage = javaType.errorMessage().map({ args0 -> args0 }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
        )
    }
}
