@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Outbound rule of the load balancer.
 * @property allocatedOutboundPorts The number of outbound ports to be used for NAT.
 * @property backendAddressPool A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
 * @property enableTcpReset Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property frontendIPConfigurations The Frontend IP addresses of the load balancer.
 * @property id Resource ID.
 * @property idleTimeoutInMinutes The timeout for the TCP idle connection.
 * @property name The name of the resource that is unique within the set of outbound rules used by the load balancer. This name can be used to access the resource.
 * @property protocol The protocol for the outbound rule in load balancer.
 * @property provisioningState The provisioning state of the outbound rule resource.
 * @property type Type of the resource.
 */
public data class OutboundRuleResponse(
    public val allocatedOutboundPorts: Int? = null,
    public val backendAddressPool: SubResourceResponse,
    public val enableTcpReset: Boolean? = null,
    public val etag: String,
    public val frontendIPConfigurations: List<SubResourceResponse>,
    public val id: String? = null,
    public val idleTimeoutInMinutes: Int? = null,
    public val name: String? = null,
    public val protocol: String,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.OutboundRuleResponse):
            OutboundRuleResponse = OutboundRuleResponse(
            allocatedOutboundPorts = javaType.allocatedOutboundPorts().map({ args0 -> args0 }).orElse(null),
            backendAddressPool = javaType.backendAddressPool().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
            }),
            enableTcpReset = javaType.enableTcpReset().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            frontendIPConfigurations = javaType.frontendIPConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            idleTimeoutInMinutes = javaType.idleTimeoutInMinutes().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
