@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Parameters for an Action.
 * @property asPath List of AS paths.
 * @property community List of BGP communities.
 * @property routePrefix List of route prefixes.
 */
public data class ParameterResponse(
    public val asPath: List<String>? = null,
    public val community: List<String>? = null,
    public val routePrefix: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ParameterResponse):
            ParameterResponse = ParameterResponse(
            asPath = javaType.asPath().map({ args0 -> args0 }),
            community = javaType.community().map({ args0 -> args0 }),
            routePrefix = javaType.routePrefix().map({ args0 -> args0 }),
        )
    }
}
