@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * PrivateDnsZoneConfig resource.
 * @property name Name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property privateDnsZoneId The resource id of the private dns zone.
 * @property recordSets A collection of information regarding a recordSet, holding information to identify private resources.
 */
public data class PrivateDnsZoneConfigResponse(
    public val name: String? = null,
    public val privateDnsZoneId: String? = null,
    public val recordSets: List<RecordSetResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.PrivateDnsZoneConfigResponse):
            PrivateDnsZoneConfigResponse = PrivateDnsZoneConfigResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            privateDnsZoneId = javaType.privateDnsZoneId().map({ args0 -> args0 }).orElse(null),
            recordSets = javaType.recordSets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RecordSetResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
