@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * PrivateLinkServiceConnection resource.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property groupIds The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property privateLinkServiceConnectionState A collection of read-only information about the state of the connection to the remote resource.
 * @property privateLinkServiceId The resource id of private link service.
 * @property provisioningState The provisioning state of the private link service connection resource.
 * @property requestMessage A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars.
 * @property type The resource type.
 */
public data class PrivateLinkServiceConnectionResponse(
    public val etag: String,
    public val groupIds: List<String>? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse? = null,
    public val privateLinkServiceId: String? = null,
    public val provisioningState: String,
    public val requestMessage: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.PrivateLinkServiceConnectionResponse):
            PrivateLinkServiceConnectionResponse = PrivateLinkServiceConnectionResponse(
            etag = javaType.etag(),
            groupIds = javaType.groupIds().map({ args0 -> args0 }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceId = javaType.privateLinkServiceId().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            requestMessage = javaType.requestMessage().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
