@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collective group of information about the record set information.
 * @property fqdn Fqdn that resolves to private endpoint ip address.
 * @property ipAddresses The private ip address of the private endpoint.
 * @property provisioningState The provisioning state of the recordset.
 * @property recordSetName Recordset name.
 * @property recordType Resource record type.
 * @property ttl Recordset time to live.
 */
public data class RecordSetResponse(
    public val fqdn: String? = null,
    public val ipAddresses: List<String>? = null,
    public val provisioningState: String,
    public val recordSetName: String? = null,
    public val recordType: String? = null,
    public val ttl: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.RecordSetResponse):
            RecordSetResponse = RecordSetResponse(
            fqdn = javaType.fqdn().map({ args0 -> args0 }).orElse(null),
            ipAddresses = javaType.ipAddresses().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            recordSetName = javaType.recordSetName().map({ args0 -> args0 }).orElse(null),
            recordType = javaType.recordType().map({ args0 -> args0 }).orElse(null),
            ttl = javaType.ttl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
