@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Suppress

/**
 * Routing Configuration indicating the associated and propagated route tables for this connection.
 * @property associatedRouteTable The resource id RouteTable associated with this RoutingConfiguration.
 * @property inboundRouteMap The resource id of the RouteMap associated with this RoutingConfiguration for inbound learned routes.
 * @property outboundRouteMap The resource id of theRouteMap associated with this RoutingConfiguration for outbound advertised routes.
 * @property propagatedRouteTables The list of RouteTables to advertise the routes to.
 * @property vnetRoutes List of routes that control routing from VirtualHub into a virtual network connection.
 */
public data class RoutingConfigurationResponse(
    public val associatedRouteTable: SubResourceResponse? = null,
    public val inboundRouteMap: SubResourceResponse? = null,
    public val outboundRouteMap: SubResourceResponse? = null,
    public val propagatedRouteTables: PropagatedRouteTableResponse? = null,
    public val vnetRoutes: VnetRouteResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.RoutingConfigurationResponse):
            RoutingConfigurationResponse = RoutingConfigurationResponse(
            associatedRouteTable = javaType.associatedRouteTable().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            inboundRouteMap = javaType.inboundRouteMap().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            outboundRouteMap = javaType.outboundRouteMap().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            propagatedRouteTables = javaType.propagatedRouteTables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PropagatedRouteTableResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vnetRoutes = javaType.vnetRoutes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VnetRouteResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
