@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property description Describes what is the signature enforces
 * @property destinationPorts Describes the list of destination ports related to this signature
 * @property direction Describes in which direction signature is being enforced: 0 - Inbound, 1 - OutBound, 2 - Bidirectional
 * @property group Describes the groups the signature belongs to
 * @property inheritedFromParentPolicy Describes if this override is inherited from base policy or not
 * @property lastUpdated Describes the last updated time of the signature (provided from 3rd party vendor)
 * @property mode The current mode enforced, 0 - Disabled, 1 - Alert, 2 -Deny
 * @property protocol Describes the protocol the signatures is being enforced in
 * @property severity Describes the severity of signature: 1 - Low, 2 - Medium, 3 - High
 * @property signatureId The ID of the signature
 * @property sourcePorts Describes the list of source ports related to this signature
 */
public data class SingleQueryResultResponse(
    public val description: String? = null,
    public val destinationPorts: List<String>? = null,
    public val direction: Int? = null,
    public val group: String? = null,
    public val inheritedFromParentPolicy: Boolean? = null,
    public val lastUpdated: String? = null,
    public val mode: Int? = null,
    public val protocol: String? = null,
    public val severity: Int? = null,
    public val signatureId: Int? = null,
    public val sourcePorts: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.SingleQueryResultResponse):
            SingleQueryResultResponse = SingleQueryResultResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinationPorts = javaType.destinationPorts().map({ args0 -> args0 }),
            direction = javaType.direction().map({ args0 -> args0 }).orElse(null),
            group = javaType.group().map({ args0 -> args0 }).orElse(null),
            inheritedFromParentPolicy = javaType.inheritedFromParentPolicy().map({ args0 ->
                args0
            }).orElse(null),
            lastUpdated = javaType.lastUpdated().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            severity = javaType.severity().map({ args0 -> args0 }).orElse(null),
            signatureId = javaType.signatureId().map({ args0 -> args0 }).orElse(null),
            sourcePorts = javaType.sourcePorts().map({ args0 -> args0 }),
        )
    }
}
