@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Configuration for static routes on this HubVnetConnectionConfiguration for static routes on this HubVnetConnection.
 * @property propagateStaticRoutes Boolean indicating whether static routes on this connection are automatically propagate to route tables which this connection propagates to.
 * @property vnetLocalRouteOverrideCriteria Parameter determining whether NVA in spoke vnet is bypassed for traffic with destination in spoke.
 */
public data class StaticRoutesConfigResponse(
    public val propagateStaticRoutes: Boolean,
    public val vnetLocalRouteOverrideCriteria: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.StaticRoutesConfigResponse):
            StaticRoutesConfigResponse = StaticRoutesConfigResponse(
            propagateStaticRoutes = javaType.propagateStaticRoutes(),
            vnetLocalRouteOverrideCriteria = javaType.vnetLocalRouteOverrideCriteria().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
