@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Network Virtual Appliance Additional NIC properties.
 * @property hasPublicIp Flag (true or false) for Intent for Public Ip on additional nic
 * @property name Name of additional nic
 */
public data class VirtualApplianceAdditionalNicPropertiesResponse(
    public val hasPublicIp: Boolean? = null,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VirtualApplianceAdditionalNicPropertiesResponse):
            VirtualApplianceAdditionalNicPropertiesResponse =
            VirtualApplianceAdditionalNicPropertiesResponse(
                hasPublicIp = javaType.hasPublicIp().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
            )
    }
}
