@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Network Virtual Appliance NIC properties.
 * @property instanceName Instance on which nic is attached.
 * @property name NIC name.
 * @property privateIpAddress Private IP address.
 * @property publicIpAddress Public IP address.
 */
public data class VirtualApplianceNicPropertiesResponse(
    public val instanceName: String,
    public val name: String,
    public val privateIpAddress: String,
    public val publicIpAddress: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VirtualApplianceNicPropertiesResponse):
            VirtualApplianceNicPropertiesResponse = VirtualApplianceNicPropertiesResponse(
            instanceName = javaType.instanceName(),
            name = javaType.name(),
            privateIpAddress = javaType.privateIpAddress(),
            publicIpAddress = javaType.publicIpAddress(),
        )
    }
}
