@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Vpn NatRule mapping.
 * @property addressSpace Address space for Vpn NatRule mapping.
 * @property portRange Port range for Vpn NatRule mapping.
 */
public data class VpnNatRuleMappingResponse(
    public val addressSpace: String? = null,
    public val portRange: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VpnNatRuleMappingResponse):
            VpnNatRuleMappingResponse = VpnNatRuleMappingResponse(
            addressSpace = javaType.addressSpace().map({ args0 -> args0 }).orElse(null),
            portRange = javaType.portRange().map({ args0 -> args0 }).orElse(null),
        )
    }
}
