@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Allow certain variables to be scrubbed on WAF logs
 * @property matchVariable The variable to be scrubbed from the logs.
 * @property selector When matchVariable is a collection, operator used to specify which elements in the collection this rule applies to.
 * @property selectorMatchOperator When matchVariable is a collection, operate on the selector to specify which elements in the collection this rule applies to.
 * @property state Defines the state of log scrubbing rule. Default value is Enabled.
 */
public data class WebApplicationFirewallScrubbingRulesResponse(
    public val matchVariable: String,
    public val selector: String? = null,
    public val selectorMatchOperator: String,
    public val state: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.WebApplicationFirewallScrubbingRulesResponse):
            WebApplicationFirewallScrubbingRulesResponse = WebApplicationFirewallScrubbingRulesResponse(
            matchVariable = javaType.matchVariable(),
            selector = javaType.selector().map({ args0 -> args0 }).orElse(null),
            selectorMatchOperator = javaType.selectorMatchOperator(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
