@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin

import com.pulumi.azurenative.networkanalytics.DataTypeArgs.builder
import com.pulumi.azurenative.networkanalytics.kotlin.enums.DataTypeState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The data type resource.
 * Azure REST API version: 2023-11-15.
 * ## Example Usage
 * ### DataTypes_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataType = new AzureNative.NetworkAnalytics.DataType("dataType", new()
 *     {
 *         DataProductName = "dataproduct01",
 *         DataTypeName = "datatypename",
 *         DatabaseCacheRetention = 23,
 *         DatabaseRetention = 6,
 *         ResourceGroupName = "aoiresourceGroupName",
 *         State = "STARTED",
 *         StorageOutputRetention = 27,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkanalytics.NewDataType(ctx, "dataType", &networkanalytics.DataTypeArgs{
 * 			DataProductName:        pulumi.String("dataproduct01"),
 * 			DataTypeName:           pulumi.String("datatypename"),
 * 			DatabaseCacheRetention: pulumi.Int(23),
 * 			DatabaseRetention:      pulumi.Int(6),
 * 			ResourceGroupName:      pulumi.String("aoiresourceGroupName"),
 * 			State:                  pulumi.String("STARTED"),
 * 			StorageOutputRetention: pulumi.Int(27),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkanalytics.DataType;
 * import com.pulumi.azurenative.networkanalytics.DataTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataType = new DataType("dataType", DataTypeArgs.builder()
 *             .dataProductName("dataproduct01")
 *             .dataTypeName("datatypename")
 *             .databaseCacheRetention(23)
 *             .databaseRetention(6)
 *             .resourceGroupName("aoiresourceGroupName")
 *             .state("STARTED")
 *             .storageOutputRetention(27)
 *             .build());
 *     }
 * }
 * ```
 * ### DataTypes_Create_MaximumSet_Gen - generated by [MinimumSet] rule_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataType = new AzureNative.NetworkAnalytics.DataType("dataType", new()
 *     {
 *         DataProductName = "dataproduct01",
 *         DataTypeName = "datatypename",
 *         ResourceGroupName = "aoiresourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkanalytics.NewDataType(ctx, "dataType", &networkanalytics.DataTypeArgs{
 * 			DataProductName:   pulumi.String("dataproduct01"),
 * 			DataTypeName:      pulumi.String("datatypename"),
 * 			ResourceGroupName: pulumi.String("aoiresourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkanalytics.DataType;
 * import com.pulumi.azurenative.networkanalytics.DataTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataType = new DataType("dataType", DataTypeArgs.builder()
 *             .dataProductName("dataproduct01")
 *             .dataTypeName("datatypename")
 *             .resourceGroupName("aoiresourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkanalytics:DataType datatypeName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}/dataTypes/{dataTypeName}
 * ```
 * @property dataProductName The data product resource name
 * @property dataTypeName The data type name.
 * @property databaseCacheRetention Field for database cache retention in days.
 * @property databaseRetention Field for database data retention in days.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property state State of data type.
 * @property storageOutputRetention Field for storage output retention in days.
 */
public data class DataTypeArgs(
    public val dataProductName: Output<String>? = null,
    public val dataTypeName: Output<String>? = null,
    public val databaseCacheRetention: Output<Int>? = null,
    public val databaseRetention: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val state: Output<Either<String, DataTypeState>>? = null,
    public val storageOutputRetention: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkanalytics.DataTypeArgs> {
    override fun toJava(): com.pulumi.azurenative.networkanalytics.DataTypeArgs =
        com.pulumi.azurenative.networkanalytics.DataTypeArgs.builder()
            .dataProductName(dataProductName?.applyValue({ args0 -> args0 }))
            .dataTypeName(dataTypeName?.applyValue({ args0 -> args0 }))
            .databaseCacheRetention(databaseCacheRetention?.applyValue({ args0 -> args0 }))
            .databaseRetention(databaseRetention?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storageOutputRetention(storageOutputRetention?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataTypeArgs].
 */
@PulumiTagMarker
public class DataTypeArgsBuilder internal constructor() {
    private var dataProductName: Output<String>? = null

    private var dataTypeName: Output<String>? = null

    private var databaseCacheRetention: Output<Int>? = null

    private var databaseRetention: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var state: Output<Either<String, DataTypeState>>? = null

    private var storageOutputRetention: Output<Int>? = null

    /**
     * @param value The data product resource name
     */
    @JvmName("ftkkjrimfqftetry")
    public suspend fun dataProductName(`value`: Output<String>) {
        this.dataProductName = value
    }

    /**
     * @param value The data type name.
     */
    @JvmName("sxcxjcrfvprrdubv")
    public suspend fun dataTypeName(`value`: Output<String>) {
        this.dataTypeName = value
    }

    /**
     * @param value Field for database cache retention in days.
     */
    @JvmName("gyeuotmciflkspeo")
    public suspend fun databaseCacheRetention(`value`: Output<Int>) {
        this.databaseCacheRetention = value
    }

    /**
     * @param value Field for database data retention in days.
     */
    @JvmName("pcghftymiffvslly")
    public suspend fun databaseRetention(`value`: Output<Int>) {
        this.databaseRetention = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wsyfovcnsvpcemfk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value State of data type.
     */
    @JvmName("uhimmnfpnjnptysg")
    public suspend fun state(`value`: Output<Either<String, DataTypeState>>) {
        this.state = value
    }

    /**
     * @param value Field for storage output retention in days.
     */
    @JvmName("ymlfuigdoestffgp")
    public suspend fun storageOutputRetention(`value`: Output<Int>) {
        this.storageOutputRetention = value
    }

    /**
     * @param value The data product resource name
     */
    @JvmName("lasjnpxdfklebryn")
    public suspend fun dataProductName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataProductName = mapped
    }

    /**
     * @param value The data type name.
     */
    @JvmName("prjsvbikvdsetrfy")
    public suspend fun dataTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataTypeName = mapped
    }

    /**
     * @param value Field for database cache retention in days.
     */
    @JvmName("qiwenhslbviygtlx")
    public suspend fun databaseCacheRetention(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseCacheRetention = mapped
    }

    /**
     * @param value Field for database data retention in days.
     */
    @JvmName("fiknwcndeuennksw")
    public suspend fun databaseRetention(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseRetention = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vxoddoejubyjjsck")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value State of data type.
     */
    @JvmName("xyinkbeblrcugneq")
    public suspend fun state(`value`: Either<String, DataTypeState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value State of data type.
     */
    @JvmName("gsgrdtveglwklusf")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataTypeState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value State of data type.
     */
    @JvmName("kxlwnpyatgxficuy")
    public fun state(`value`: DataTypeState) {
        val toBeMapped = Either.ofRight<String, DataTypeState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Field for storage output retention in days.
     */
    @JvmName("bpxeoygwjuxvebhn")
    public suspend fun storageOutputRetention(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageOutputRetention = mapped
    }

    internal fun build(): DataTypeArgs = DataTypeArgs(
        dataProductName = dataProductName,
        dataTypeName = dataTypeName,
        databaseCacheRetention = databaseCacheRetention,
        databaseRetention = databaseRetention,
        resourceGroupName = resourceGroupName,
        state = state,
        storageOutputRetention = storageOutputRetention,
    )
}
